	function [hMP, ZerosMP] = MIN_PHASE_LP_FIR(Norder, wT, d);
 
	%	Computes the impulse response and the zeros for a minimum-phase FIR filter
 
	%	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Hakan Johansson 2003-08-06
	% 	Modified by: 	LW 2003-08-06, 2005-06-26
	% 	Copyright:		by authors - not released for commercial use
	% 	Version 		1
	% 	Report bugs to:	Wanhammar@gmail.com
	
	% References:	G.A. Mian and A.P. Nainer, A fast procedure to design 
	%				equiripple minimum-phase FIR filters, IEEE Trans. Circuits Syst.,
	%				vol. CAS-29, no. 5, pp. 327331, May 1982.
 
	% See also: gremez, firminphase
 
		dc = d(1);
		ds = d(2);
		d1 = 2*dc/(1+dc*dc-0.5*ds*ds);
		d2 = 0.5*ds*ds/(1+dc*dc-0.5*ds*ds);
		[n0, Be, D, W] = HERRMANN_LP_FIR_ORDER(wT, [d1 d2]);
		if Norder == 0
			Norder = 2*ceil(n0/2);
		else
			Norder = 2*Norder;
		end
		% Design a linear-phase FIR filter
		[hLP, Err] = REMEZ_FIR(Norder, Be, D, W, 'sym');
		
		z = zeros(1,length(hLP));
		z(0.5*(length(hLP)+1)) = 1;
		points = 2000;
		wT = linspace(wT(2),pi,points);
		HLP = freqz(hLP,1,wT);
		hLP = hLP + max(abs(HLP))*z;
		
		d = 1.02;
		N = 8*(length(hLP));
		n = 0:length(hLP)-1;
		h2 = hLP.*d.^(-n);
		H2 = fft(h2,N);
		wT = linspace(0, 2*pi -2*pi/N, N);
		s = 0;
		R = roots(hLP);
		for r = 1:length(R)
			if abs(R(r))<0.97
				s = s+1;
			end
		end
		N2 = s;
		Z = (d^N2)*exp(j*wT*N2);
		H2 = Z.*H2;
		Mag = log(abs(H2))+j*unwrap(angle(H2));
		
		%plot(unwrap(angle(H2)))
		%c1 = ifft(Mag,N);
		c1 = 0;
		k = 0:N-1;
		for n = -N/2:N/2-1
			c1(n+N/2+1) = sum((1/N)*Mag.*exp(j*2*pi*k*n/N));
		end
		n = -N/2:N/2-1;
		c1 = c1.*d.^n;
		c1 = real(c1(N/2+1-0.5*(length(h2)-1):N/2+1+0.5*(length(h2)-1)));
		
		%c2 = c1;
		c2 = 0.5*c1(0.5*(length(c1)+1):length(c1))+0.5*[0 fliplr(c1(1:0.5*(length(c1)-1)))];
		g = 0;
		g(1) = exp(c2(1));
		for n = 1:length(c2)-1
			g(n+1) = c2(n+1)*g(1);
			for k = 1:n-1
				g(n+1) = g(n+1)+(k/n)*c2(k+1)*g(n-k+1);
			end
		end
	
		wT = linspace(0, pi, points);
		HMP = freqz(g,1,wT);		 
		hMP = 2*g/(max(abs(HMP))+min(abs(HMP)));
	
		% polish the zeros on the unit circle
		ZerosMP = roots(hMP); % Zeros of HMP(z)
		delta = 0.01;
		for i = 1:length(ZerosMP)
			if (abs(ZerosMP(i))>=(1-delta) & abs(ZerosMP(i))<=(1+delta))
				ZerosMP(i) = ZerosMP(i)/abs(ZerosMP(i));
			end
		end
		P = zeros(length(hMP)-1,1);
		hMP = poly(ZerosMP); 	
		HMP = freqz(hMP,1,wT);
		Max = max(abs(HMP)); % Scale maximal gain to 1 
		hMP = (1/Max)*hMP;
